/****************************************************************************
 **                                                                        **
 **  Win32 audio subsystem using MIDAS v1.1.2 library - Aron, 1998.11.06   **
 **                                                                        **
 ****************************************************************************/

// - szabvany fejlecfile-ok -------------------------------------------------
#include <stdlib.h>
#include <windows.h>

// - sajat fejlecfile-ok ----------------------------------------------------
#include "\librarie.s\midas.112\include\midasdll.h"
#include "Audio.hpp"

// - implementacio ----------------------------------------------------------
BOOL bMIDASInitialized= FALSE;

MIDASmodule modModule;
MIDASmodulePlayHandle hPlaying;

DWORD dwSyncValue;

void MIDASExit(HWND hWnd)
{ 
	// legutobbi hibauzenet es kilepes:
	int i= MIDASgetLastError();

	if(i)
	{
		char lpszError[256];
		strcpy(lpszError,MIDASgetErrorMessage(i)); strcat(lpszError,"!");
	
		MessageBox(hWnd,lpszError,"MIDAS Error",MB_ICONERROR | MB_OK);
	}

	MIDASclose();
	exit(0); // kivenni es a H-t is!
	//PostMessage(hWnd,WM_DESTROY,0,0);
}

void MIDAS_CALL SyncronizingCallback(unsigned syncInfo,unsigned position,unsigned row)
{ 
	// syncvalue elmentese:
	dwSyncValue= syncInfo;
}

void InitAudioSystem(HWND hWnd)
{ 
	// eloszor hivando MIDAS fuggveny:
	MIDASstartup();

	// opciok beallitasa:
	MIDASsetOption(MIDAS_OPTION_DSOUND_MODE,MIDAS_DSOUND_PRIMARY);	
	MIDASsetOption(MIDAS_OPTION_DSOUND_HWND,(DWORD)hWnd);
	MIDASsetOption(MIDAS_OPTION_MIXING_MODE,MIDAS_MIX_HIGH_QUALITY);
}

void SetupAudioSystem(HWND hWnd)
{
	// konfiguracios panel megjelenitese:
    MIDASconfig();
}

void CloseAudioSystem(HWND hWnd)
{ 
	bMIDASInitialized= FALSE;
	
	// lejatszas megallitasa:
	if(bMIDASInitialized) if(!MIDASstopModule(hPlaying)) MIDASExit(hWnd);

	// polling megszuntetese:
	if(!MIDASstopBackgroundPlay()) MIDASExit(hWnd);

	// modul felszabaditasa:
	if(!MIDASfreeModule(modModule)) MIDASExit(hWnd);

	// szinkronfuggveny leszedese:
	//if(musicstarted) 
	if(!MIDASsetMusicSyncCallback(hPlaying,NULL)) MIDASExit(hWnd);
	
	// MIDAS lezarasa:
	if(!MIDASclose()) MIDASExit(hWnd);
}

void StartMusic(HWND hWnd,DWORD dwStartPos)
{ 
	// MIDAS inicializalas:
	if(!MIDASinit()) MIDASExit(hWnd);

	// automatikus polling beallitasa:
	if(!MIDASstartBackgroundPlay(10)) MIDASExit(hWnd);
  
	// zene betoltese:
	if(!(modModule= MIDASloadModule(MODULE_FILENAME))) MIDASExit(hWnd);

	// lejatszas elkezdese (2. parameter a loop-olas ill. az effektcsatornak szama):
	if((hPlaying= MIDASplayModule(modModule,TRUE)) == NULL) MIDASExit(hWnd);

	// szinkronfuggveny idozitese:
	if(!MIDASsetMusicSyncCallback(hPlaying,&SyncronizingCallback)) MIDASExit(hWnd);

	// kezdo pos beallitasa:
	if(!MIDASsetPosition(hPlaying,dwStartPos)) MIDASExit(hWnd);

	// ha minden OK volt:
	bMIDASInitialized= TRUE;
}
